-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.limit = 4
    self.pos = self:GetPosition()
    self.p0 = Citadels.GetPlayer(0)
    self.p1 = Citadels.GetPlayer(1)
    
    if not self.loaded then
      self.active = true
      self.timer = self.limit
    end
    
    self.fortCaptured:LinkToTarget("buildingOwner")
    self.fortCaptured:LinkToTarget("deactivateFoAtt")
    self.fortCaptured:LinkToTarget("activateAttacks")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      CheckUnits(self)
      self.timer = self.limit
    end
  end  
end

function CheckUnits(self)
  p0units = self.p0:UnitsInRadiusNumber(self.pos, 4000, '*')
  p1units = self.p1:UnitsInRadiusNumber(self.pos, 4000, '*')
  
  if p0units == 0 and p1units >= 5 then
    self.fortCaptured:TriggerAllTargets()
    self.active = false
  else
    return
  end  
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("fortCaptured")
end
